<?php 
 $GLOBALS["dictionary"]["AOS_PDF_Templates"]=array (
  'table' => 'aos_pdf_templates',
  'audited' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => true,
      'importable' => 'required',
      'duplicate_merge' => 'enabled',
      'merge_filter' => 'selected',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'longtext',
      'comment' => 'Full text of the note',
      'rows' => '6',
      'cols' => '80',
      'required' => false,
      'massupdate' => 0,
      'no_default' => false,
      'comments' => 'Full text of the note',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'securitygroup' => 
    array (
      'name' => 'securitygroup',
      'vname' => 'LBL_SECURITYGROUP',
      'type' => 'enum',
      'source' => 'non-db',
      'function' => 'getUserSecurityGroups',
      'default' => '0',
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the search forms',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'readonly' => true,
      'studio' => 
      array (
        'visible' => false,
        'listview' => false,
        'searchview' => true,
        'detailview' => false,
        'editview' => false,
        'formula' => false,
        'related' => false,
        'basic_search' => true,
        'advanced_search' => true,
        'popuplist' => false,
        'popupsearch' => true,
        'dashletsearch' => true,
        'dashlet' => false,
      ),
    ),
    'securitygroup_display' => 
    array (
      'name' => 'securitygroup_display',
      'vname' => 'LBL_SECURITYGROUP',
      'type' => 'function',
      'function_name' => 'getRecordSecurityGroups',
      'function_params' => 
      array (
        0 => 'id',
      ),
      'source' => 'non-db',
      'function' => 
      array (
        'name' => 'getRecordSecurityGroups',
        'returns' => 'html',
        'onListView' => true,
      ),
      'custom_type' => 'securitygroup',
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the list, detail, and edit views',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'readonly' => true,
      'studio' => 
      array (
        'visible' => false,
        'listview' => true,
        'searchview' => false,
        'detailview' => true,
        'editview' => true,
        'formula' => false,
        'related' => false,
        'basic_search' => false,
        'advanced_search' => false,
        'popuplist' => true,
        'popupsearch' => false,
        'dashletsearch' => false,
        'dashlet' => false,
      ),
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'aos_pdf_templates_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'aos_pdf_templates_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'aos_pdf_templates_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'additionalusers' => 
    array (
      'name' => 'additionalusers',
      'vname' => 'LBL_ADDITIONALUSERS',
      'type' => 'additionalusers',
      'source' => 'non-db',
      'function' => 
      array (
        'name' => 'getAdditionalUsers',
        'include' => 'modules/SecurityGroups/SecurityGroupAdditionalUser.php',
      ),
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the list, detail, and edit views',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'studio' => 
      array (
        'visible' => false,
        'listview' => false,
        'searchview' => false,
        'detailview' => true,
        'editview' => true,
        'formula' => false,
        'related' => false,
        'basic_search' => false,
        'advanced_search' => false,
        'popuplist' => false,
        'popupsearch' => false,
        'dashletsearch' => false,
        'dashlet' => false,
        'quickcreate' => true,
      ),
    ),
    'additionalusers_listview' => 
    array (
      'name' => 'additionalusers_listview',
      'vname' => 'LBL_ADDITIONALUSERS',
      'type' => 'function',
      'function_name' => 'getAdditionalUsers_List',
      'function_params' => 
      array (
        0 => 'id',
      ),
      'source' => 'non-db',
      'function' => 
      array (
        'name' => 'getAdditionalUsers_List',
        'include' => 'modules/SecurityGroups/SecurityGroupAdditionalUser.php',
        'returns' => 'html',
        'onListView' => false,
      ),
      'module' => 'AOS_PDF_Templates',
      'custom_type' => 'additionalusers',
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the list, detail, and edit views',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'readonly' => true,
      'studio' => 
      array (
        'visible' => true,
        'listview' => true,
        'searchview' => false,
        'detailview' => false,
        'editview' => false,
        'formula' => false,
        'related' => false,
        'basic_search' => false,
        'advanced_search' => false,
        'popuplist' => true,
        'popupsearch' => false,
        'dashletsearch' => false,
        'dashlet' => false,
      ),
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_aos_pdf_templates',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'active' => 
    array (
      'name' => 'active',
      'vname' => 'LBL_ACTIVE',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => true,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => 0,
      'studio' => 'visible',
    ),
    'type' => 
    array (
      'required' => '1',
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => '',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => 0,
      'len' => 100,
      'options' => 'pdf_template_type_dom',
      'studio' => 'visible',
    ),
    'sample' => 
    array (
      'required' => '0',
      'name' => 'sample',
      'vname' => 'LBL_SAMPLE',
      'source' => 'non-db',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => '',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => 0,
      'len' => 100,
      'options' => 'pdf_template_sample_dom',
      'studio' => 'visible',
    ),
    'insert_fields' => 
    array (
      'required' => '0',
      'name' => 'insert_fields',
      'vname' => 'LBL_INSERT_FIELDS',
      'studio' => 'visible',
      'source' => 'non-db',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => '',
      'comments' => '',
      'help' => '',
      'reportable' => 0,
    ),
    'pdfheader' => 
    array (
      'required' => false,
      'name' => 'pdfheader',
      'vname' => 'LBL_HEADER',
      'type' => 'longtext',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'pdffooter' => 
    array (
      'required' => false,
      'name' => 'pdffooter',
      'vname' => 'LBL_FOOTER',
      'type' => 'longtext',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'margin_left' => 
    array (
      'required' => false,
      'name' => 'margin_left',
      'vname' => 'LBL_MARGIN_LEFT',
      'type' => 'int',
      'massupdate' => 0,
      'default' => '15',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
    ),
    'margin_right' => 
    array (
      'required' => false,
      'name' => 'margin_right',
      'vname' => 'LBL_MARGIN_RIGHT',
      'type' => 'int',
      'massupdate' => 0,
      'default' => '15',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
    ),
    'margin_top' => 
    array (
      'required' => false,
      'name' => 'margin_top',
      'vname' => 'LBL_MARGIN_TOP',
      'type' => 'int',
      'massupdate' => 0,
      'default' => '16',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
    ),
    'margin_bottom' => 
    array (
      'required' => false,
      'name' => 'margin_bottom',
      'vname' => 'LBL_MARGIN_BOTTOM',
      'type' => 'int',
      'massupdate' => 0,
      'default' => '16',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
    ),
    'margin_header' => 
    array (
      'required' => false,
      'name' => 'margin_header',
      'vname' => 'LBL_MARGIN_HEADER',
      'type' => 'int',
      'massupdate' => 0,
      'default' => '9',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
    ),
    'margin_footer' => 
    array (
      'required' => false,
      'name' => 'margin_footer',
      'vname' => 'LBL_MARGIN_FOOTER',
      'type' => 'int',
      'massupdate' => 0,
      'default' => '9',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
    ),
    'page_size' => 
    array (
      'required' => '0',
      'name' => 'page_size',
      'vname' => 'LBL_PAGE_SIZE',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => '',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => 0,
      'len' => 100,
      'options' => 'pdf_page_size_dom',
      'studio' => 'visible',
    ),
    'orientation' => 
    array (
      'required' => '0',
      'name' => 'orientation',
      'vname' => 'LBL_ORIENTATION',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => '',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => 0,
      'len' => 100,
      'options' => 'pdf_orientation_dom',
      'studio' => 'visible',
    ),
  ),
  'relationships' => 
  array (
    'aos_pdf_templates_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_PDF_Templates',
      'rhs_table' => 'aos_pdf_templates',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'aos_pdf_templates_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_PDF_Templates',
      'rhs_table' => 'aos_pdf_templates',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'aos_pdf_templates_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_PDF_Templates',
      'rhs_table' => 'aos_pdf_templates',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_aos_pdf_templates' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_PDF_Templates',
      'rhs_table' => 'aos_pdf_templates',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'AOS_PDF_Templates',
    ),
  ),
  'optimistic_locking' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'aos_pdf_templatespk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => false,
);