<?php 
 $GLOBALS["dictionary"]["InboundEmail"]=array (
  'table' => 'inbound_email',
  'inline_edit' => false,
  'massupdate' => false,
  'duplicate_merge' => false,
  'comment' => 'Inbound email parameters',
  'audited' => false,
  'fields' => 
  array (
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_inbound_email',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'dbType' => 'varchar',
      'len' => 36,
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Unique identifier',
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'required' => false,
      'default' => '0',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Record deltion indicator',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Date record created',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Date record last modified',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED_BY',
      'type' => 'modified_user_name',
      'table' => 'users',
      'isnull' => false,
      'dbType' => 'id',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'User who last modified record',
    ),
    'modified_user_id_link' => 
    array (
      'name' => 'modified_user_id_link',
      'type' => 'link',
      'relationship' => 'inbound_email_modified_user_id',
      'vname' => 'LBL_MODIFIED_BY_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_ASSIGNED_TO',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => false,
      'dbType' => 'id',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'User who created record',
    ),
    'owner_name' => 
    array (
      'name' => 'owner_name',
      'rname' => 'name',
      'id_name' => 'created_by',
      'vname' => 'LBL_OWNER_NAME',
      'join_name' => 'owner_user',
      'type' => 'relate',
      'link' => 'created_by_link',
      'table' => 'users',
      'isnull' => 'true',
      'module' => 'Users',
      'dbType' => 'varchar',
      'len' => '255',
      'source' => 'non-db',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'inbound_email_created_by',
      'vname' => 'LBL_CREATED_BY_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'varchar',
      'len' => '255',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Name given to the inbound email mailbox',
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'options' => 'dom_inbound_email_account_status',
      'len' => 100,
      'default' => 'Active',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Status of the inbound email mailbox (ex: Active or Inactive)',
    ),
    'email_body_filtering' => 
    array (
      'name' => 'email_body_filtering',
      'vname' => 'LBL_EMAIL_BODY_FILTERING',
      'type' => 'enum',
      'default' => 'multi',
      'options' => 'dom_email_body_filtering_option',
      'reportable' => false,
      'inline_edit' => false,
      'unified_search' => false,
      'comment' => 'Set the filtering type for the emails body on listview',
    ),
    'server_url' => 
    array (
      'name' => 'server_url',
      'vname' => 'LBL_SERVER_URL',
      'type' => 'varchar',
      'len' => '100',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Mail server URL',
    ),
    'connection_string' => 
    array (
      'name' => 'connection_string',
      'vname' => 'LBL_CONNECTION_STRING',
      'type' => 'varchar',
      'placeholder' => 'LBL_OPTIONAL_CONNECTION_STRING',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Mail server Connection string',
    ),
    'email_user' => 
    array (
      'name' => 'email_user',
      'vname' => 'LBL_LOGIN',
      'type' => 'varchar',
      'len' => '100',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'User name allowed access to mail server',
    ),
    'email_password' => 
    array (
      'name' => 'email_password',
      'vname' => 'LBL_PASSWORD',
      'type' => 'password',
      'dbType' => 'varchar',
      'display' => 'writeonly',
      'len' => '100',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'sensitive' => true,
      'api-visible' => false,
      'comment' => 'Password of user identified by email_user',
    ),
    'port' => 
    array (
      'name' => 'port',
      'vname' => 'LBL_SERVER_PORT',
      'type' => 'int',
      'len' => '5',
      'default' => '143',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'validation' => 
      array (
        'type' => 'range',
        'min' => '110',
        'max' => '65535',
      ),
      'comment' => 'Port used to access mail server',
    ),
    'service' => 
    array (
      'name' => 'service',
      'vname' => 'LBL_SERVICE',
      'type' => 'varchar',
      'len' => '50',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => '',
    ),
    'mailbox' => 
    array (
      'name' => 'mailbox',
      'vname' => 'LBL_MAILBOX',
      'type' => 'text',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => '',
    ),
    'sentFolder' => 
    array (
      'name' => 'sentFolder',
      'vname' => 'LBL_SENT_FOLDER',
      'type' => 'varchar',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'trashFolder' => 
    array (
      'name' => 'trashFolder',
      'vname' => 'LBL_TRASH_FOLDER',
      'type' => 'varchar',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'delete_seen' => 
    array (
      'name' => 'delete_seen',
      'vname' => 'LBL_DELETE_SEEN',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Delete email from server once read (seen)',
    ),
    'move_messages_to_trash_after_import' => 
    array (
      'name' => 'move_messages_to_trash_after_import',
      'vname' => 'LBL_MOVE_MESSAGES_TO_TRASH_AFTER_IMPORT',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'mailbox_type' => 
    array (
      'name' => 'mailbox_type',
      'vname' => 'LBL_MAILBOX_TYPE',
      'type' => 'varchar',
      'len' => '10',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => '',
    ),
    'template_id' => 
    array (
      'name' => 'template_id',
      'vname' => 'LBL_AUTOREPLY',
      'type' => 'id',
      'len' => '36',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Template used for auto-reply',
    ),
    'stored_options' => 
    array (
      'name' => 'stored_options',
      'vname' => 'LBL_STORED_OPTIONS',
      'type' => 'text',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => '',
    ),
    'group_id' => 
    array (
      'name' => 'group_id',
      'vname' => 'LBL_GROUP_ID',
      'type' => 'id',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Group ID (unused)',
    ),
    'is_personal' => 
    array (
      'name' => 'is_personal',
      'vname' => 'LBL_IS_PERSONAL',
      'type' => 'bool',
      'required' => true,
      'default' => '0',
      'reportable' => false,
      'massupdate' => '',
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Personal account flag',
    ),
    'groupfolder_id' => 
    array (
      'name' => 'groupfolder_id',
      'vname' => 'LBL_GROUPFOLDER_ID',
      'type' => 'id',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'comment' => 'Unique identifier',
    ),
    'type' => 
    array (
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'dom_inbound_email_account_types',
      'display' => 'readonly',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'auth_type' => 
    array (
      'name' => 'auth_type',
      'vname' => 'LBL_AUTH_TYPE',
      'type' => 'enum',
      'options' => 'dom_inbound_email_auth_types',
      'default' => 'basic',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'protocol' => 
    array (
      'name' => 'protocol',
      'vname' => 'LBL_PROTOCOL',
      'type' => 'enum',
      'options' => 'dom_email_server_type',
      'function' => 'getInboundEmailProtocols',
      'default' => 'imap',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'is_ssl' => 
    array (
      'name' => 'is_ssl',
      'vname' => 'LBL_SSL',
      'type' => 'bool',
      'required' => false,
      'default' => '0',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'is_default' => 
    array (
      'name' => 'is_default',
      'vname' => 'LBL_IS_DEFAULT',
      'type' => 'bool',
      'required' => false,
      'default' => '0',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'from_name' => 
    array (
      'name' => 'from_name',
      'vname' => 'LBL_FROM_NAME',
      'type' => 'varchar',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'from_addr' => 
    array (
      'name' => 'from_addr',
      'vname' => 'LBL_FROM_ADDR',
      'type' => 'varchar',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'reply_to_name' => 
    array (
      'name' => 'reply_to_name',
      'vname' => 'LBL_REPLY_TO_NAME',
      'type' => 'varchar',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'reply_to_addr' => 
    array (
      'name' => 'reply_to_addr',
      'vname' => 'LBL_REPLY_TO_ADDR',
      'type' => 'varchar',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'account_signature_id' => 
    array (
      'name' => 'account_signature_id',
      'vname' => 'LBL_SIGNATURE',
      'function' => 
      array (
        'name' => 'getUserSignature',
        'returns' => 'html',
        'include' => 'modules/InboundEmail/utils.php',
      ),
      'type' => 'varchar',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'filter_domain' => 
    array (
      'name' => 'filter_domain',
      'vname' => 'LBL_FILTER_DOMAIN',
      'type' => 'varchar',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'email_num_autoreplies_24_hours' => 
    array (
      'name' => 'email_num_autoreplies_24_hours',
      'vname' => 'LBL_MAX_AUTO_REPLIES',
      'type' => 'int',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'is_auto_import' => 
    array (
      'name' => 'is_auto_import',
      'vname' => 'LBL_ENABLE_AUTO_IMPORT',
      'type' => 'bool',
      'required' => false,
      'default' => '0',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'is_create_case' => 
    array (
      'name' => 'is_create_case',
      'vname' => 'LBL_CREATE_CASE',
      'type' => 'bool',
      'required' => false,
      'default' => '0',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'allow_outbound_group_usage' => 
    array (
      'name' => 'allow_outbound_group_usage',
      'vname' => 'LBL_ALLOW_OUTBOUND_GROUP_USAGE',
      'type' => 'bool',
      'required' => false,
      'default' => '0',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'distrib_method' => 
    array (
      'name' => 'distrib_method',
      'vname' => 'LBL_DISTRIB_METHOD',
      'type' => 'enum',
      'options' => 'dom_email_distribution_for_auto_create',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'distribution_options' => 
    array (
      'name' => 'distribution_options',
      'vname' => 'LBL_DISTRIB_OPTIONS',
      'function' => 
      array (
        'name' => 'getInboundEmailDistributionOptions',
        'returns' => 'html',
        'include' => 'modules/InboundEmail/utils.php',
      ),
      'type' => 'function',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'source' => 'non-db',
    ),
    'distribution_user' => 
    array (
      'name' => 'distribution_user',
      'type' => 'link',
      'relationship' => 'inbound_emails_distribution_user',
      'link_type' => 'one',
      'source' => 'non-db',
      'vname' => 'LBL_DISTRIBUTION_USER',
      'duplicate_merge' => 'disabled',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'distribution_user_id' => 
    array (
      'name' => 'distribution_user_id',
      'rname' => 'id',
      'id_name' => 'distribution_user_id',
      'vname' => 'LBL_DISTRIBUTION_USER_ID',
      'type' => 'relate',
      'table' => 'users',
      'isnull' => 'true',
      'module' => 'Users',
      'dbType' => 'id',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'duplicate_merge' => 'disabled',
      'hideacl' => true,
    ),
    'distribution_user_name' => 
    array (
      'name' => 'distribution_user_name',
      'rname' => 'name',
      'id_name' => 'distribution_user_id',
      'vname' => 'LBL_DISTRIBUTION_USER_NAME',
      'join_name' => 'distribution_user',
      'type' => 'relate',
      'link' => 'distribution_user',
      'table' => 'users',
      'isnull' => 'true',
      'module' => 'Users',
      'dbType' => 'varchar',
      'len' => '255',
      'source' => 'non-db',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'outbound_email' => 
    array (
      'name' => 'outbound_email',
      'type' => 'link',
      'relationship' => 'inbound_outbound_email_accounts',
      'link_type' => 'one',
      'source' => 'non-db',
      'vname' => 'LBL_OUTBOUND_EMAIL_ACCOUNT',
      'duplicate_merge' => 'disabled',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'outbound_email_id' => 
    array (
      'name' => 'outbound_email_id',
      'rname' => 'id',
      'id_name' => 'outbound_email_id',
      'vname' => 'LBL_OUTBOUND_EMAIL_ACCOUNT_ID',
      'type' => 'relate',
      'table' => 'outbound_email',
      'isnull' => 'true',
      'module' => 'OutboundEmailAccounts',
      'dbType' => 'id',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'duplicate_merge' => 'disabled',
      'hideacl' => true,
    ),
    'outbound_email_name' => 
    array (
      'name' => 'outbound_email_name',
      'rname' => 'name',
      'id_name' => 'outbound_email_id',
      'vname' => 'LBL_OUTBOUND_EMAIL_ACCOUNT_NAME',
      'join_name' => 'outbound_email',
      'type' => 'relate',
      'link' => 'outbound_email',
      'table' => 'outbound_email',
      'isnull' => 'true',
      'module' => 'OutboundEmailAccounts',
      'dbType' => 'varchar',
      'len' => '255',
      'source' => 'non-db',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'autoreply_email_template' => 
    array (
      'name' => 'autoreply_email_template',
      'type' => 'link',
      'relationship' => 'inbound_emails_autoreply_email_templates',
      'link_type' => 'one',
      'source' => 'non-db',
      'vname' => 'LBL_AUTOREPLY_EMAIL_TEMPLATE',
      'duplicate_merge' => 'disabled',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'autoreply_email_template_name' => 
    array (
      'name' => 'autoreply_email_template_name',
      'rname' => 'name',
      'id_name' => 'template_id',
      'vname' => 'LBL_AUTOREPLY_EMAIL_TEMPLATE_NAME',
      'join_name' => 'email_templates',
      'type' => 'relate',
      'link' => 'autoreply_email_template',
      'table' => 'email_templates',
      'isnull' => 'true',
      'module' => 'EmailTemplates',
      'dbType' => 'varchar',
      'len' => '255',
      'source' => 'non-db',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'create_case_email_template' => 
    array (
      'name' => 'create_case_email_template',
      'type' => 'link',
      'relationship' => 'inbound_emails_case_email_templates',
      'link_type' => 'one',
      'source' => 'non-db',
      'vname' => 'LBL_CASE_EMAIL_TEMPLATE',
      'duplicate_merge' => 'disabled',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'create_case_template_id' => 
    array (
      'name' => 'create_case_template_id',
      'rname' => 'id',
      'id_name' => 'create_case_template_id',
      'vname' => 'LBL_CASE_EMAIL_TEMPLATE_ID',
      'type' => 'relate',
      'table' => 'email_templates',
      'isnull' => 'true',
      'module' => 'EmailTemplates',
      'dbType' => 'id',
      'duplicate_merge' => 'disabled',
      'hideacl' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'create_case_email_template_name' => 
    array (
      'name' => 'create_case_email_template_name',
      'rname' => 'name',
      'id_name' => 'create_case_template_id',
      'vname' => 'LBL_CASE_EMAIL_TEMPLATE_NAME',
      'join_name' => 'email_templates',
      'type' => 'relate',
      'link' => 'create_case_email_template',
      'table' => 'email_templates',
      'isnull' => 'true',
      'module' => 'EmailTemplates',
      'dbType' => 'varchar',
      'len' => '255',
      'source' => 'non-db',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'external_oauth_connection' => 
    array (
      'name' => 'external_oauth_connection',
      'type' => 'link',
      'relationship' => 'inbound_emails_external_oauth_connections',
      'link_type' => 'one',
      'source' => 'non-db',
      'vname' => 'LBL_EXTERNAL_OAUTH_CONNECTION',
      'duplicate_merge' => 'disabled',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'external_oauth_connection_id' => 
    array (
      'name' => 'external_oauth_connection_id',
      'rname' => 'id',
      'id_name' => 'external_oauth_connection_id',
      'vname' => 'LBL_EXTERNAL_OAUTH_CONNECTION_ID',
      'type' => 'relate',
      'table' => 'external_oauth_connections',
      'isnull' => 'true',
      'module' => 'ExternalOAuthConnection',
      'dbType' => 'id',
      'duplicate_merge' => 'disabled',
      'hideacl' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'external_oauth_connection_name' => 
    array (
      'name' => 'external_oauth_connection_name',
      'rname' => 'name',
      'id_name' => 'external_oauth_connection_id',
      'vname' => 'LBL_EXTERNAL_OAUTH_CONNECTION_NAME',
      'join_name' => 'external_oauth_connections',
      'type' => 'relate',
      'link' => 'external_oauth_connection',
      'table' => 'external_oauth_connections',
      'isnull' => 'true',
      'module' => 'ExternalOAuthConnection',
      'dbType' => 'varchar',
      'len' => '255',
      'source' => 'non-db',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
  ),
  'indices' => 
  array (
    0 => 
    array (
      'name' => 'inbound_emailpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'relationships' => 
  array (
    'securitygroups_inboundemail' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'InboundEmail',
      'rhs_table' => 'inbound_email',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'InboundEmail',
    ),
    'inbound_emails_distribution_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'InboundEmail',
      'rhs_table' => 'inbound_email',
      'rhs_key' => 'distribution_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'inbound_emails_autoreply_email_templates' => 
    array (
      'lhs_module' => 'EmailTemplates',
      'lhs_table' => 'email_templates',
      'lhs_key' => 'id',
      'rhs_module' => 'InboundEmail',
      'rhs_table' => 'inbound_email',
      'rhs_key' => 'template_id',
      'relationship_type' => 'one-to-many',
    ),
    'inbound_emails_case_email_templates' => 
    array (
      'lhs_module' => 'EmailTemplates',
      'lhs_table' => 'email_templates',
      'lhs_key' => 'id',
      'rhs_module' => 'InboundEmail',
      'rhs_table' => 'inbound_email',
      'rhs_key' => 'create_case_template_id',
      'relationship_type' => 'one-to-many',
    ),
    'inbound_emails_external_oauth_connections' => 
    array (
      'lhs_module' => 'ExternalOAuthConnection',
      'lhs_table' => 'external_oauth_connections',
      'lhs_key' => 'id',
      'rhs_module' => 'InboundEmail',
      'rhs_table' => 'inbound_email',
      'rhs_key' => 'external_oauth_connection_id',
      'relationship_type' => 'one-to-many',
    ),
    'inbound_outbound_email_accounts' => 
    array (
      'lhs_module' => 'OutboundEmailAccounts',
      'lhs_table' => 'outbound_email',
      'lhs_key' => 'id',
      'rhs_module' => 'InboundEmail',
      'rhs_table' => 'inbound_email',
      'rhs_key' => 'outbound_email_id',
      'relationship_type' => 'one-to-many',
    ),
    'inbound_email_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'InboundEmail',
      'rhs_table' => 'inbound_email',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-one',
    ),
    'inbound_email_modified_user_id' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'InboundEmail',
      'rhs_table' => 'inbound_email',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-one',
    ),
  ),
  'templates' => 
  array (
    'security_groups' => 'security_groups',
  ),
  'custom_fields' => false,
);