<?php 
 $GLOBALS["dictionary"]["OAuth2Clients"]=array (
  'table' => 'oauth2clients',
  'audited' => false,
  'comment' => 'Provides tokens for security services',
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => false,
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'varchar',
      'required' => true,
      'reportable' => false,
      'inline_edit' => false,
      'duplicate_merge' => 'disabled',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'securitygroup' => 
    array (
      'name' => 'securitygroup',
      'vname' => 'LBL_SECURITYGROUP',
      'type' => 'enum',
      'source' => 'non-db',
      'function' => 'getUserSecurityGroups',
      'default' => '0',
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the search forms',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'readonly' => true,
      'studio' => 
      array (
        'visible' => false,
        'listview' => false,
        'searchview' => true,
        'detailview' => false,
        'editview' => false,
        'formula' => false,
        'related' => false,
        'basic_search' => true,
        'advanced_search' => true,
        'popuplist' => false,
        'popupsearch' => true,
        'dashletsearch' => true,
        'dashlet' => false,
      ),
    ),
    'securitygroup_display' => 
    array (
      'name' => 'securitygroup_display',
      'vname' => 'LBL_SECURITYGROUP',
      'type' => 'function',
      'function_name' => 'getRecordSecurityGroups',
      'function_params' => 
      array (
        0 => 'id',
      ),
      'source' => 'non-db',
      'function' => 
      array (
        'name' => 'getRecordSecurityGroups',
        'returns' => 'html',
        'onListView' => true,
      ),
      'custom_type' => 'securitygroup',
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the list, detail, and edit views',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'readonly' => true,
      'studio' => 
      array (
        'visible' => false,
        'listview' => true,
        'searchview' => false,
        'detailview' => true,
        'editview' => true,
        'formula' => false,
        'related' => false,
        'basic_search' => false,
        'advanced_search' => false,
        'popuplist' => true,
        'popupsearch' => false,
        'dashletsearch' => false,
        'dashlet' => false,
      ),
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'oauth2clients_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'oauth2clients_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'secret' => 
    array (
      'name' => 'secret',
      'vname' => 'LBL_SECRET',
      'type' => 'varchar',
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
      'len' => '4000',
    ),
    'redirect_url' => 
    array (
      'name' => 'redirect_url',
      'vname' => 'LBL_REDIRECT_URL',
      'type' => 'varchar',
      'required' => false,
      'reportable' => false,
      'inline_edit' => false,
    ),
    'is_confidential' => 
    array (
      'name' => 'is_confidential',
      'vname' => 'LBL_IS_CONFIDENTIAL',
      'type' => 'bool',
      'default' => true,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
    ),
    'allowed_grant_type' => 
    array (
      'name' => 'allowed_grant_type',
      'vname' => 'LBL_ALLOWED_GRANT_TYPE',
      'type' => 'enum',
      'options' => 'oauth2_grant_type_dom',
      'default' => 'password',
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
    ),
    'duration_value' => 
    array (
      'name' => 'duration_value',
      'vname' => 'LBL_DURATION_VALUE',
      'type' => 'int',
      'len' => 11,
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
    ),
    'duration_amount' => 
    array (
      'name' => 'duration_amount',
      'vname' => 'LBL_DURATION_AMOUNT',
      'type' => 'int',
      'len' => 11,
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
    ),
    'duration_unit' => 
    array (
      'name' => 'duration_unit',
      'vname' => 'LBL_DURATION_UNIT',
      'type' => 'enum',
      'options' => 'oauth2_duration_units',
      'default' => 'Duration Unit',
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
    ),
    'oauth2tokens' => 
    array (
      'name' => 'oauth2tokens',
      'vname' => 'LBL_RELATED_OAUTH2TOKENS',
      'type' => 'link',
      'relationship' => 'oauth2clients_oauth2tokens',
      'module' => 'OAuth2Tokens',
      'bean_name' => 'OAuth2Tokens',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_USER',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_USER',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'required' => true,
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'oauth2clients_assigned_user',
      'vname' => 'LBL_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
  ),
  'optimistic_locking' => true,
  'relationships' => 
  array (
    'oauth2clients_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OAuth2Clients',
      'rhs_table' => 'oauth2clients',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'oauth2clients_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OAuth2Clients',
      'rhs_table' => 'oauth2clients',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'oauth2clients_oauth2tokens' => 
    array (
      'rhs_module' => 'OAuth2Tokens',
      'rhs_table' => 'oauth2tokens',
      'rhs_key' => 'client',
      'lhs_module' => 'OAuth2Clients',
      'lhs_table' => 'oauth2clients',
      'lhs_key' => 'id',
      'relationship_type' => 'one-to-many',
    ),
    'oauth2clients_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OAuth2Clients',
      'rhs_table' => 'oauth2clients',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'oauth2clientspk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'basic' => 'basic',
  ),
  'custom_fields' => false,
);