<?php 
 $GLOBALS["dictionary"]["OAuth2Tokens"]=array (
  'table' => 'oauth2tokens',
  'audited' => false,
  'comment' => 'Provides tokens for security services',
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => true,
      'importable' => 'required',
      'duplicate_merge' => 'enabled',
      'merge_filter' => 'selected',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'securitygroup' => 
    array (
      'name' => 'securitygroup',
      'vname' => 'LBL_SECURITYGROUP',
      'type' => 'enum',
      'source' => 'non-db',
      'function' => 'getUserSecurityGroups',
      'default' => '0',
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the search forms',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'readonly' => true,
      'studio' => 
      array (
        'visible' => false,
        'listview' => false,
        'searchview' => true,
        'detailview' => false,
        'editview' => false,
        'formula' => false,
        'related' => false,
        'basic_search' => true,
        'advanced_search' => true,
        'popuplist' => false,
        'popupsearch' => true,
        'dashletsearch' => true,
        'dashlet' => false,
      ),
    ),
    'securitygroup_display' => 
    array (
      'name' => 'securitygroup_display',
      'vname' => 'LBL_SECURITYGROUP',
      'type' => 'function',
      'function_name' => 'getRecordSecurityGroups',
      'function_params' => 
      array (
        0 => 'id',
      ),
      'source' => 'non-db',
      'function' => 
      array (
        'name' => 'getRecordSecurityGroups',
        'returns' => 'html',
        'onListView' => true,
      ),
      'custom_type' => 'securitygroup',
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the list, detail, and edit views',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'readonly' => true,
      'studio' => 
      array (
        'visible' => false,
        'listview' => true,
        'searchview' => false,
        'detailview' => true,
        'editview' => true,
        'formula' => false,
        'related' => false,
        'basic_search' => false,
        'advanced_search' => false,
        'popuplist' => true,
        'popupsearch' => false,
        'dashletsearch' => false,
        'dashlet' => false,
      ),
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'oauth2tokens_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'oauth2tokens_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'token_is_revoked' => 
    array (
      'name' => 'token_is_revoked',
      'vname' => 'LBL_TOKEN_IS_REVOKED',
      'type' => 'bool',
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
    ),
    'token_type' => 
    array (
      'name' => 'token_type',
      'vname' => 'LBL_ACCESS_TOKEN_TYPE',
      'type' => 'varchar',
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
    ),
    'access_token_expires' => 
    array (
      'name' => 'access_token_expires',
      'vname' => 'LBL_ACCESS_TOKEN_EXPIRES',
      'type' => 'datetime',
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
    ),
    'access_token' => 
    array (
      'name' => 'access_token',
      'vname' => 'LBL_ACCESS_TOKEN',
      'type' => 'varchar',
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
      'len' => '4000',
      'inline_edit' => false,
    ),
    'refresh_token' => 
    array (
      'name' => 'refresh_token',
      'vname' => 'LBL_REFRESH_TOKEN',
      'type' => 'varchar',
      'required' => false,
      'reportable' => false,
      'api-visible' => false,
      'len' => '4000',
      'inline_edit' => false,
    ),
    'refresh_token_expires' => 
    array (
      'name' => 'refresh_token_expires',
      'vname' => 'LBL_REFRESH_TOKEN_EXPIRES',
      'type' => 'datetime',
      'required' => false,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
    ),
    'grant_type' => 
    array (
      'name' => 'grant_type',
      'vname' => 'LBL_GRANT_TYPE',
      'type' => 'enum',
      'options' => 'oauth2_grant_type_dom',
      'default' => '',
      'required' => true,
      'reportable' => false,
      'api-visible' => false,
      'inline_edit' => false,
    ),
    'state' => 
    array (
      'name' => 'state',
      'vname' => 'LBL_STATE',
      'type' => 'varchar',
      'required' => false,
      'reportable' => false,
      'api-visible' => false,
      'len' => '1024',
      'inline_edit' => false,
    ),
    'oauth2client_name' => 
    array (
      'required' => false,
      'name' => 'oauth2client_name',
      'rname' => 'name',
      'id_name' => 'client',
      'vname' => 'LBL_CLIENT',
      'type' => 'relate',
      'link' => 'oauth2clients',
      'table' => 'oauth2clients',
      'isnull' => 'true',
      'module' => 'OAuth2Clients',
      'dbType' => 'varchar',
      'len' => 255,
      'source' => 'non-db',
      'unified_search' => true,
      'quicksearch' => 'enabled',
      'reportable' => true,
      'inline_edit' => false,
    ),
    'oauth2clients' => 
    array (
      'name' => 'oauth2clients',
      'vname' => 'LBL_CLIENT',
      'type' => 'link',
      'relationship' => 'oauth2clients_oauth2tokens',
      'module' => 'OAuth2Clients',
      'bean_name' => 'OAuth2Clients',
      'source' => 'non-db',
      'inline_edit' => false,
    ),
    'client' => 
    array (
      'name' => 'client',
      'type' => 'relate',
      'dbType' => 'id',
      'rname' => 'id',
      'module' => 'OAuth2Clients',
      'id_name' => 'client',
      'reportable' => false,
      'vname' => 'LBL_CLIENT_ID',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_USER',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
      'inline_edit' => false,
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_USER',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'inline_edit' => false,
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'oauth2tokens_assigned_user',
      'vname' => 'LBL_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
      'inline_edit' => false,
    ),
  ),
  'optimistic_locking' => true,
  'relationships' => 
  array (
    'oauth2tokens_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OAuth2Tokens',
      'rhs_table' => 'oauth2tokens',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'oauth2tokens_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OAuth2Tokens',
      'rhs_table' => 'oauth2tokens',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'oauth2tokens_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OAuth2Tokens',
      'rhs_table' => 'oauth2tokens',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'oauth2tokenspk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'basic' => 'basic',
  ),
  'custom_fields' => false,
);