<?php 
 $GLOBALS["dictionary"]["SurveyResponses"]=array (
  'table' => 'surveyresponses',
  'audited' => true,
  'inline_edit' => true,
  'duplicate_merge' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => true,
      'importable' => 'required',
      'duplicate_merge' => 'enabled',
      'merge_filter' => 'selected',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'securitygroup' => 
    array (
      'name' => 'securitygroup',
      'vname' => 'LBL_SECURITYGROUP',
      'type' => 'enum',
      'source' => 'non-db',
      'function' => 'getUserSecurityGroups',
      'default' => '0',
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the search forms',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'readonly' => true,
      'studio' => 
      array (
        'visible' => false,
        'listview' => false,
        'searchview' => true,
        'detailview' => false,
        'editview' => false,
        'formula' => false,
        'related' => false,
        'basic_search' => true,
        'advanced_search' => true,
        'popuplist' => false,
        'popupsearch' => true,
        'dashletsearch' => true,
        'dashlet' => false,
      ),
    ),
    'securitygroup_display' => 
    array (
      'name' => 'securitygroup_display',
      'vname' => 'LBL_SECURITYGROUP',
      'type' => 'function',
      'function_name' => 'getRecordSecurityGroups',
      'function_params' => 
      array (
        0 => 'id',
      ),
      'source' => 'non-db',
      'function' => 
      array (
        'name' => 'getRecordSecurityGroups',
        'returns' => 'html',
        'onListView' => true,
      ),
      'custom_type' => 'securitygroup',
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the list, detail, and edit views',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'readonly' => true,
      'studio' => 
      array (
        'visible' => false,
        'listview' => true,
        'searchview' => false,
        'detailview' => true,
        'editview' => true,
        'formula' => false,
        'related' => false,
        'basic_search' => false,
        'advanced_search' => false,
        'popuplist' => true,
        'popupsearch' => false,
        'dashletsearch' => false,
        'dashlet' => false,
      ),
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'surveyresponses_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'surveyresponses_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'surveyresponses_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'additionalusers' => 
    array (
      'name' => 'additionalusers',
      'vname' => 'LBL_ADDITIONALUSERS',
      'type' => 'additionalusers',
      'source' => 'non-db',
      'function' => 
      array (
        'name' => 'getAdditionalUsers',
        'include' => 'modules/SecurityGroups/SecurityGroupAdditionalUser.php',
      ),
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the list, detail, and edit views',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'studio' => 
      array (
        'visible' => false,
        'listview' => false,
        'searchview' => false,
        'detailview' => true,
        'editview' => true,
        'formula' => false,
        'related' => false,
        'basic_search' => false,
        'advanced_search' => false,
        'popuplist' => false,
        'popupsearch' => false,
        'dashletsearch' => false,
        'dashlet' => false,
        'quickcreate' => true,
      ),
    ),
    'additionalusers_listview' => 
    array (
      'name' => 'additionalusers_listview',
      'vname' => 'LBL_ADDITIONALUSERS',
      'type' => 'function',
      'function_name' => 'getAdditionalUsers_List',
      'function_params' => 
      array (
        0 => 'id',
      ),
      'source' => 'non-db',
      'function' => 
      array (
        'name' => 'getAdditionalUsers_List',
        'include' => 'modules/SecurityGroups/SecurityGroupAdditionalUser.php',
        'returns' => 'html',
        'onListView' => false,
      ),
      'module' => 'SurveyResponses',
      'custom_type' => 'additionalusers',
      'sortable' => false,
      'reportable' => false,
      'comment' => 'Used for adding to the list, detail, and edit views',
      'massupdate' => false,
      'unified_search' => false,
      'importable' => 'false',
      'readonly' => true,
      'studio' => 
      array (
        'visible' => true,
        'listview' => true,
        'searchview' => false,
        'detailview' => false,
        'editview' => false,
        'formula' => false,
        'related' => false,
        'basic_search' => false,
        'advanced_search' => false,
        'popuplist' => true,
        'popupsearch' => false,
        'dashletsearch' => false,
        'dashlet' => false,
      ),
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_surveyresponses',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'question_responses_display' => 
    array (
      'name' => 'question_responses_display',
      'vname' => 'LBL_QUESTION_RESPONSES_DISPLAY',
      'type' => 'function',
      'source' => 'non-db',
      'massupdate' => 0,
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'inline_edit' => false,
      'function' => 
      array (
        'name' => 'question_responses_display',
        'returns' => 'html',
        'include' => 'modules/SurveyResponses/Lines/Lines.php',
      ),
    ),
    'happiness' => 
    array (
      'name' => 'happiness',
      'type' => 'int',
      'label' => 'LBL_HAPPINESS',
    ),
    'email_response_sent' => 
    array (
      'name' => 'email_response_sent',
      'type' => 'bool',
      'label' => 'LBL_EMAIL_RESPONSE_SENT',
    ),
    'account' => 
    array (
      'name' => 'account',
      'type' => 'link',
      'relationship' => 'surveyresponses_accounts',
      'source' => 'non-db',
      'module' => 'Accounts',
      'bean_name' => 'Account',
      'vname' => 'LBL_SURVEYRESPONSES_ACCOUNTS_FROM_ACCOUNTS_TITLE',
      'id_name' => 'account_id',
      'link_type' => 'one',
      'side' => 'left',
    ),
    'account_name' => 
    array (
      'name' => 'account_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_SURVEYRESPONSES_ACCOUNTS_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'account_id',
      'link' => 'account',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'account_id' => 
    array (
      'name' => 'account_id',
      'type' => 'id',
      'reportable' => false,
      'vname' => 'LBL_SURVEYRESPONSES_ACCOUNTS_FROM_SURVEYRESPONSES_TITLE',
    ),
    'campaign' => 
    array (
      'name' => 'campaign',
      'type' => 'link',
      'relationship' => 'surveyresponses_campaigns',
      'source' => 'non-db',
      'module' => 'Campaigns',
      'bean_name' => 'Campaign',
      'vname' => 'LBL_SURVEYRESPONSES_CAMPAIGNS_FROM_CAMPAIGNS_TITLE',
      'id_name' => 'campaign_id',
      'link_type' => 'one',
      'side' => 'left',
    ),
    'campaign_name' => 
    array (
      'name' => 'campaign_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_SURVEYRESPONSES_CAMPAIGNS_FROM_CAMPAIGNS_TITLE',
      'save' => true,
      'id_name' => 'campaign_id',
      'link' => 'campaign',
      'table' => 'campaigns',
      'module' => 'Campaigns',
      'rname' => 'name',
    ),
    'campaign_id' => 
    array (
      'name' => 'campaign_id',
      'type' => 'id',
      'reportable' => false,
      'vname' => 'LBL_SURVEYRESPONSES_CAMPAIGNS_FROM_SURVEYRESPONSES_TITLE',
    ),
    'contact' => 
    array (
      'name' => 'contact',
      'type' => 'link',
      'relationship' => 'surveyresponses_contacts',
      'source' => 'non-db',
      'module' => 'Contacts',
      'bean_name' => 'Contact',
      'vname' => 'LBL_SURVEYRESPONSES_CONTACTS_FROM_CONTACTS_TITLE',
      'id_name' => 'contact',
      'link_type' => 'one',
      'side' => 'left',
    ),
    'contact_name' => 
    array (
      'name' => 'contact_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_SURVEYRESPONSES_CONTACTS_FROM_CONTACTS_TITLE',
      'save' => true,
      'id_name' => 'contact_id',
      'link' => 'contact',
      'table' => 'contacts',
      'module' => 'Contacts',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'contact_id' => 
    array (
      'name' => 'contact_id',
      'type' => 'id',
      'reportable' => false,
      'vname' => 'LBL_SURVEYRESPONSES_CONTACTS_FROM_SURVEYRESPONSES_TITLE',
    ),
    'surveyresponses_surveyquestionresponses' => 
    array (
      'name' => 'surveyresponses_surveyquestionresponses',
      'type' => 'link',
      'relationship' => 'surveyresponses_surveyquestionresponses',
      'source' => 'non-db',
      'module' => 'SurveyQuestionResponses',
      'bean_name' => 'SurveyQuestionResponses',
      'side' => 'right',
      'vname' => 'LBL_SURVEYRESPONSES_SURVEYQUESTIONRESPONSES_FROM_SURVEYQUESTIONRESPONSES_TITLE',
    ),
    'survey' => 
    array (
      'name' => 'survey',
      'type' => 'link',
      'relationship' => 'surveys_surveyresponses',
      'source' => 'non-db',
      'module' => 'Surveys',
      'bean_name' => 'Surveys',
      'vname' => 'LBL_SURVEYS_SURVEYRESPONSES_FROM_SURVEYS_TITLE',
      'id_name' => 'survey_id',
      'link_type' => 'one',
      'side' => 'left',
    ),
    'survey_name' => 
    array (
      'name' => 'survey_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_SURVEYS_SURVEYRESPONSES_FROM_SURVEYS_TITLE',
      'save' => true,
      'id_name' => 'survey_id',
      'link' => 'survey',
      'table' => 'surveys',
      'module' => 'Surveys',
      'rname' => 'name',
    ),
    'survey_id' => 
    array (
      'name' => 'survey_id',
      'type' => 'id',
      'reportable' => false,
      'vname' => 'LBL_SURVEYS_SURVEYRESPONSES_FROM_SURVEYRESPONSES_TITLE',
    ),
  ),
  'relationships' => 
  array (
    'surveyresponses_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'SurveyResponses',
      'rhs_table' => 'surveyresponses',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'surveyresponses_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'SurveyResponses',
      'rhs_table' => 'surveyresponses',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'surveyresponses_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'SurveyResponses',
      'rhs_table' => 'surveyresponses',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_surveyresponses' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'SurveyResponses',
      'rhs_table' => 'surveyresponses',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'SurveyResponses',
    ),
    'surveyresponses_surveyquestionresponses' => 
    array (
      'rhs_module' => 'SurveyQuestionResponses',
      'rhs_table' => 'surveyquestionresponses',
      'rhs_key' => 'surveyresponse_id',
      'lhs_module' => 'SurveyResponses',
      'lhs_table' => 'surveyresponses',
      'lhs_key' => 'id',
      'relationship_type' => 'one-to-many',
    ),
    'surveyresponses_contacts' => 
    array (
      'rhs_module' => 'SurveyResponses',
      'rhs_table' => 'surveyresponses',
      'rhs_key' => 'contact_id',
      'lhs_module' => 'Contacts',
      'lhs_table' => 'contacts',
      'lhs_key' => 'id',
      'relationship_type' => 'one-to-many',
    ),
    'surveyresponses_accounts' => 
    array (
      'rhs_module' => 'SurveyResponses',
      'rhs_table' => 'surveyresponses',
      'rhs_key' => 'account_id',
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'surveyresponsespk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => false,
);