<?php

global $sugar_version, $sugar_flavor, $server_unique_key, $current_language, $app_strings;

$sugaroutfitters_url = "https://www.sugaroutfitters.com/start?utm_sugarcrm_version={$sugar_version}&utm_sugarcrm_edition={$sugar_flavor}&utm_sugarcrm_lang={$current_language}";
$sugaroutfitters_url .= "&tag=eggsurplus";

if(file_exists('suitecrm_version.php'))
{
    $sugaroutfitters_url = 'https://store.suitecrm.com?tag=eggsurplus';
}

$admin_option_defs=array();

$admin_option_defs['Administration']['securitygroup_license']= array('helpInline','LBL_SECURITYGROUPS_LICENSE_TITLE','LBL_SECURITYGROUPS_LICENSE','./index.php?module=SecurityGroups&action=license');
$admin_option_defs['Administration']['securitygroup_sugaroutfitters']= array('SugarOutfitters','LBL_SECURITYGROUPS_SUGAROUTFITTERS_TITLE','LBL_SECURITYGROUPS_SUGAROUTFITTERS',"{$sugaroutfitters_url}");

$admin_option_defs['Administration']['securitygroup_management']= array('SecurityGroups','LBL_MANAGE_SECURITYGROUPS_TITLE','LBL_MANAGE_SECURITYGROUPS','./index.php?module=SecurityGroups&action=index');
$admin_option_defs['Administration']['securitygroup_config']= array('SecurityGroups','LBL_CONFIG_SECURITYGROUPS_TITLE','LBL_CONFIG_SECURITYGROUPS','./index.php?module=SecurityGroups&action=config');

$admin_option_defs['Administration']['securitygroup_dashletpush']= array('icon_home','LBL_SECURITYGROUPS_DASHLETPUSH_TITLE','LBL_SECURITYGROUPS_DASHLETPUSH','./index.php?module=SecurityGroups&action=DashletPush');
$admin_option_defs['Administration']['securitygroup_hookup']= array('PatchUpgrades','LBL_SECURITYGROUPS_HOOKUP_TITLE','LBL_SECURITYGROUPS_HOOKUP','./index.php?module=SecurityGroups&action=Hookup');

$admin_option_defs['Administration']['securitygroup_info']= array('helpInline','LBL_SECURITYGROUPS_INFO_TITLE','LBL_SECURITYGROUPS_INFO','https://www.sugaroutfitters.com/docs/securitysuite');

if(file_exists('suitecrm_version.php'))
{
    $admin_option_defs['Administration']['securitygroup_sugaroutfitters']= array('p_list_search','&nbsp;&nbsp;&nbsp;The SuiteCRM Store','Find more add-ons for SuiteCRM.',"{$sugaroutfitters_url}");
    $admin_option_defs['Administration']['securitygroup_info']= array('helpInline','LBL_SECURITYGROUPS_INFO_TITLE','LBL_SECURITYGROUPS_INFO','https://store.suitecrm.com/docs/securitysuite');
}

$admin_group_header[]= array('LBL_SECURITYGROUPS','',false,$admin_option_defs, '');


//BEGIN - SECURITY GROUPS - special user admin role - create/edit users - no role editing
require_once('modules/SecurityGroups/license/SecuritySuiteOutfittersLicense.php');
$current_plan = SecuritySuiteOutfittersLicense::get_current_plan();
if (!empty($current_plan) && ($current_plan == 'professional' || $current_plan == 'enterprise'))
{
	global $current_user;
	if(ACLAction::getUserAccessLevel($current_user->id,'Users', 'admin') == ACL_ALLOW_USER_ADMIN)
	{
		$access = $current_user->getDeveloperModules();
		foreach ($admin_group_header as $key=>$values) {
			$module_index = array_keys($values[3]);  //get the actual links..
			foreach ($module_index as $mod_key=>$mod_val) {
				if (is_admin($current_user) ||
					in_array($mod_val, $access) ||
				    $mod_val=='studio'||
				    ($mod_val=='Forecasts' && in_array('ForecastSchedule', $access)) ||
				    ($mod_val =='any')
				   ) {
		                //BEGIN - SECURITY GROUPS - special user admin role - create/edit users - no role editing
		                if(isset($values[3]['Users']['roles_management']))
		                {
		                    unset($admin_group_header[$key][3]['Users']['roles_management']);
		                }
		                if(isset($values[3]['studio']))
		                {
		                    unset($admin_group_header[$key][3]['studio']);
		                }
		                if(isset($values[3]['any']))
		                {
		                    unset($admin_group_header[$key][3]['any']['dropdowneditor']);
		                }
		                //END - SECURITY GROUPS
		        } else {
		        	//hide the link
		        	unset($admin_group_header[$key][3][$mod_val]);
		        }

			}

		    //BEGIN - SECURITY GROUPS - special user admin role - create/edit users - no role editing
		    if(isset($values[0]) && $values[0] == 'LBL_STUDIO_TITLE')
		    {
		        unset($admin_group_header[$key]);
		    }
		    //END - SECURITY GROUPS
		}
	}
}
//END - SECURITY GROUPS - special user admin role

