<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/MVC/View/views/view.detail.php');

class ACLRolesViewClassic extends ViewDetail {
	
    public function __construct()
    {
        parent::__construct();

        //turn off normal display of subpanels
        $this->options['show_subpanels'] = false; //no longer works in 6.3.0
    }

 	function ACLRolesViewClassic(){
 		parent::ViewDetail();

        //turn off normal display of subpanels
        $this->options['show_subpanels'] = false; //no longer works in 6.3.0
 	}

 	function display(){
		$this->dv->process();
		echo '<style type="text/css">@import url("custom/modules/ACLRoles/styles/securitygroups.css"); </style>';

		$file = SugarController::getActionFilename($this->action);
		$this->includeClassicFile('modules/'. $this->module . '/'. $file . '.php');
 	}

 	function preDisplay(){

        //BEGIN - SECURITY GROUPS - special user admin role - create/edit users - no role editing
        require_once('modules/SecurityGroups/license/SecuritySuiteOutfittersLicense.php');
        $current_plan = SecuritySuiteOutfittersLicense::get_current_plan();
        if (!empty($current_plan) && ($current_plan == 'professional' || $current_plan == 'enterprise'))
        {
        	global $current_user;
   			if(ACLAction::getUserAccessLevel($current_user->id,'Users', 'admin') == ACL_ALLOW_USER_ADMIN)
   			{
				//check action and if not DetailView then deny, otherwise redirect action 
				if(empty($this->action) || $this->action != 'DetailView')
				{
					//deny access
					$GLOBALS['log']->debug("No access to this action: ".$this->action);
					//redirect to detail view
					SugarApplication::redirect('index.php?module=ACLRoles&action=index');
				}
				else
				{
					//user role view (no edit access)
					//$GLOBALS['log']->debug("Redirect to safe detail view");
				}
			}
        }
        //END - SECURITY GROUPS
		parent::preDisplay();

		$this->options['show_subpanels'] = false; //eggsurplus: will display subpanels twice otherwise
 	}
}
