<?php
/**
 * CSRF validation is mandatory starting from 7.8.0.0
 *
 * It can be configured in config_override.php with
 * $sugar_config['csrf']['soft_fail_form'] = true/false
 */

$csrfData = PlatformConnector::getCSRF();
$moduleName = PlatformConnector::$moduleName;
$rootUrl = PlatformConnector::getUrl();
$siteUrl = PlatformConnector::getSiteUrl();

// Javascript Link Template should be formatted like ES6 string templates
$jsLinkTemplate = 'index.php?module=${this.module}&action=DetailView&record=${this.entityId}';
if(PlatformConnector::isSidecar()) {
    $jsLinkTemplate = $siteUrl . '/#${this.module}/${this.entityId}';
}

/**
 * SuiteCRM have no CSRF, so we should skip adding empty ampersand,
 * because no $csrfData["string"]. It will mame more cleaner URL
 */
$csrfUrlString = "";
if(!empty($csrfData["string"])) {
    $csrfUrlString = "&{$csrfData["string"]}";
}

$baseUrl = "index.php?module={$moduleName}";
$baseBwcUrl = "{$rootUrl}?module={$moduleName}";

$baseWithActionUrl = "{$baseUrl}&action=";
$baseBwcWithActionUrl = "{$baseBwcUrl}&action=";

$rootDir = dirname(dirname(__DIR__)) . DIRECTORY_SEPARATOR;

return  array(
    'moduleName' => $moduleName,
    'rootUrl' => $rootUrl,
    'jsLinkTemplate' => $jsLinkTemplate,
    'path' => array(
        'rootDir' => $rootDir,
        'mapData' => $rootDir . 'data' . DIRECTORY_SEPARATOR . 'map' . DIRECTORY_SEPARATOR,
    ),
    'url' => array(
        'base' => "{$baseUrl}",
        'baseCSRF' => "{$baseUrl}{$csrfUrlString}",
        'index' => "{$baseWithActionUrl}listview",
        'indexCSRF' => "{$baseWithActionUrl}listview{$csrfUrlString}",
        'withoutAction' => "{$baseWithActionUrl}",
        'withoutActionCSRF' => "{$baseUrl}{$csrfUrlString}&action=",

        // Report builder
        'reportBuilder' => '',
        'reportBuilderSimple' => "{$baseWithActionUrl}reportBuilderSimple",
        'reportBuilderExtended' => "{$baseWithActionUrl}reportBuilderExtended",
        'reportBuilderCSRF' => "{$baseWithActionUrl}reportBuilderSimple{$csrfUrlString}", //TODO: Remove
        'reportBuilderSave' => "{$baseWithActionUrl}reportBuilderSave",
        'reportBuilderEdit' => "{$baseWithActionUrl}reportBuilderEdit&reportId=",

        // Settings
        'settings' => "{$baseWithActionUrl}settings",
        'settingsCSRF' => "{$baseWithActionUrl}settings{$csrfUrlString}",
        'saveSettingsUrl' => "{$baseWithActionUrl}saveSettings",
        'getSettings' => "{$baseWithActionUrl}getSettings",

        // License
        'getLicenseData' => "{$baseWithActionUrl}getLicenseData{$csrfUrlString}",
        'getLicenseUserList' => "{$baseWithActionUrl}getLicenseUserList{$csrfUrlString}",

        // Templates
        'getTemplates' => "{$baseWithActionUrl}getTemplates",
        'downloadTemplate' => "index.php?entryPoint=downloadTemplate&templateId=", // Using Sugar Entry Point registry
        'saveTemplate' => "{$baseWithActionUrl}saveTemplate",
        'uploadTemplateLink' => "{$baseWithActionUrl}settings&currentTab=4&reportId=",
        'deleteTemplate' => "{$baseWithActionUrl}deleteTemplate",

        // Processes
        "getProcesses" => "{$baseWithActionUrl}getProcesses",
        "deleteProcess" => "{$baseWithActionUrl}deleteProcess",
        "clearProcessCache" => "{$baseWithActionUrl}clearProcessCache",
        "runProcess" => "{$baseWithActionUrl}runProcess",
        "saveProcess" => "{$baseWithActionUrl}saveProcess",

        // Scheduler
        "getScheduledReports" => "{$baseWithActionUrl}getScheduledReports",
        'runSchedulerDebug' => "{$baseWithActionUrl}run_scheduler{$csrfUrlString}",
        'forceSendReport' => "{$baseWithActionUrl}force_send_report{$csrfUrlString}",
        'getScheduledItemUserList' => "{$baseWithActionUrl}getScheduledItemUserList{$csrfUrlString}",
        'updateScheduledNextTime' => "{$baseWithActionUrl}updateScheduledNextTime{$csrfUrlString}",
        'updateScheduledMultipleNextTime' => "{$baseWithActionUrl}updateScheduledMultipleNextTime{$csrfUrlString}",
        'updateScheduledMultipleStatus' => "{$baseWithActionUrl}updateScheduledMultipleStatus{$csrfUrlString}",

        // Scheduled Dashboards
        "getScheduledDashboards" => "{$baseWithActionUrl}getScheduledDashboards",
        'runDashboardSchedulerDebug' => "{$baseWithActionUrl}run_dashboard_scheduler{$csrfUrlString}",
        'forceSendDashboard' => "{$baseWithActionUrl}force_send_dashboard{$csrfUrlString}",

        // Logs
        "clearLogs" => "{$baseWithActionUrl}clearLogs",
        "fetchLogs" => "{$baseWithActionUrl}getLogs",

        // Reports and dashboards
        'delete' => "{$baseWithActionUrl}Delete{$csrfUrlString}&record=", // @deprecated, use deleteReport instead
        'deleteReport' => "{$baseWithActionUrl}deleteReport{$csrfUrlString}&record=",
        'deleteDashboard' => "{$baseWithActionUrl}deleteDashboard&dashboardId=",
        'hideReport' => "{$baseWithActionUrl}toggleVisibility&key=report&value=0{$csrfUrlString}&record=",
        'unhideReport' => "{$baseWithActionUrl}toggleVisibility&key=report&value=1{$csrfUrlString}&record=",
        'hideCategory' => "{$baseWithActionUrl}toggleVisibility&key=category&value=0{$csrfUrlString}&record=",
        'unhideCategory' => "{$baseWithActionUrl}toggleVisibility&key=category&value=1{$csrfUrlString}&record=",
        'hideDashboard' => "{$baseWithActionUrl}toggleVisibility&key=dashboard&value=0{$csrfUrlString}&record=",
        'unhideDashboard' => "{$baseWithActionUrl}toggleVisibility&key=dashboard&value=1{$csrfUrlString}&record=",
        'createDashboard' => "{$baseUrl}{$csrfUrlString}&action=createDashboard&dashboardId=",

        'loadReportTree' => "{$baseWithActionUrl}loadReportTree",
        'report' => "{$baseBwcWithActionUrl}report&record=",
        'reportCSRF' => "{$baseBwcWithActionUrl}report{$csrfUrlString}&record=",
        'reportFull' => "{$baseBwcWithActionUrl}report{$csrfUrlString}&record=", // Used for sending report and link to report in email
        'loadReport' => "{$baseWithActionUrl}loadReport&record=",
        'saveReport' => "{$baseWithActionUrl}saveReport",
        'debug' => "{$baseWithActionUrl}debug&record=",

        'loadPicklists' => "{$baseWithActionUrl}loadPicklists",
        'loadRoles' => "{$baseWithActionUrl}getAllowedAddToDashboardRoles",
        'loadUsers' => "{$baseWithActionUrl}getAllowedUserList",
        'calculatedFieldSQL' => "{$baseWithActionUrl}calculatedFieldSQL",


        // Export
        'makeXLS' => "{$baseWithActionUrl}makeXLS&record=",
        'makePDF' => "{$baseWithActionUrl}makePDF&record=",
        'makePDFXLS' => "{$baseWithActionUrl}makePDFXLS&record=",
        'makeCSV' => "{$baseWithActionUrl}makeCSV&record=",
        'getXLSWorksheets' => "{$baseWithActionUrl}getXLSWorksheets&templateId=",

        // Actions
        'addToTargetList' => "{$baseWithActionUrl}addToTargetList",
        'loadTargetLists' => "{$baseWithActionUrl}loadTargetLists",

        // Google sync
        'getGoogleSync' => "{$baseWithActionUrl}getGoogleSync",
        'postGoogleSync' => "{$baseWithActionUrl}postGoogleSync",

        'saveToDashboard' => "{$baseWithActionUrl}addToDashboard",
        'list' => "{$baseBwcWithActionUrl}index",
        'dashboard' => "{$baseBwcWithActionUrl}dashboard&dashboardId=",
        'dashboardFull' => "{$rootUrl}?module={$moduleName}&action=dashboard{$csrfUrlString}&dashboardId=",
        'openDashboard' => "{$rootUrl}?module={$moduleName}&action=dashboard{$csrfUrlString}&dashboardId=",
        'saveCategoryUrl' => "{$baseWithActionUrl}saveCategory&to_pdf=1{$csrfUrlString}",
        'massScheduleUrl' => "{$baseWithActionUrl}massSchedule&to_pdf=1{$csrfUrlString}",
        'exportReportsUrl' => "{$baseWithActionUrl}exportReports{$csrfUrlString}",
        'importReportsUrl' => "{$baseWithActionUrl}importReports{$csrfUrlString}",
        'checkFontsAjax' => "{$baseUrl}&to_pdf=1{$csrfUrlString}",
        'downloadFontCheckUrl' => "{$baseUrl}&to_pdf=1&action=downloadFontCheck{$csrfUrlString}",
        'downloadFontUrl' => "{$baseUrl}&to_pdf=1&action=downloadFont{$csrfUrlString}",

        'userDetailView' => "{$rootUrl}?module=Users&action=DetailView{$csrfUrlString}&record=",

        // Dashboard URL's
        'saveDashboardUrl' => "{$baseWithActionUrl}saveDashboard",
        'fetchDashboardWidgetsUrl' => "{$baseWithActionUrl}getDashboardWidgets&get_pdf=1&dashboardId=",
        'fetchWidgetDataUrl' => "{$baseWithActionUrl}getWidgetData&reportId=",
        'fetchMapDataUrl' => "{$baseWithActionUrl}loadMapData",
        'fetchReportListUrl' => "{$baseWithActionUrl}getReportList&placeholder=1",
        'fetchReportTree' => "{$baseWithActionUrl}getReportTree&placeholder=1",
        'savePermissionsUrl' => "{$baseWithActionUrl}savePermissions",
        'saveScheduleUrl' => "{$baseWithActionUrl}saveSchedule",

        // Link to version comparison
        'compareVersions' => "https://www.bisapiens.com/public/file/solution/art-sugarcrm/Comparison_PRO_Basic_Analytic_Reporting_for_SugarCRM.pdf",
    ),
    'dateMySqlFormat' => array(
        "microsecond" => "MICROSECOND",
        "second" => "SECOND",
        "minute" => "MINUTE",
        "hour" => "HOUR",
        "day" => "DAY",
        "week" => "WEEK",
        "month" => "MONTH",
        "quarter" => "QUARTER",
        "year" => "YEAR"
    ),
    'customSqlBlacklist' => array(
        'select ', 'insert ', 'update ', 'delete ', ' file ', 'create ', 'alter ', 'index ', 'drop ', 'temporary ', 'show ', 'view ', 'routine ', 'execute ', 'trigger ', 'grant ', 'super ', 'process ', 'reload ', 'shutdown ', 'databases ', 'lock ', 'tables ', 'references ', 'replication ', '--', 'join '
    )

);
