<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('modules/AnalyticReporting/controllers/ARController.php');
require_once('modules/AnalyticReporting/controllers/ARDashboardController.php');

global $mod_strings, $app_strings, $sugar_config;

$items = array();
$viewMapping = null;

$canView = ACLController::checkAccess('AnalyticReporting', 'view', true);

if ($canView) {
    $arCtrl = new ARDashboardController();
    $items = $arCtrl->getDashboardList();
    // get mapping if has access to module
    $viewMapping = $arCtrl->getViewMapping();
}

foreach($items as $item) {
    $uri = $viewMapping['urls']['dashboard'] . $item['id'];

    $module_menu[] = array($uri, $item['title'], "", "AnalyticReporting");
}

// Suitecrm 8.x will not display module menu without translations
global $suitecrm_version;
if(!empty($suitecrm_version) && version_compare($suitecrm_version, '8.0.0') >= 0) {
    $module_menu = array();
}