<?php

require_once('modules/AnalyticReporting/controllers/ARController.php');
require_once('modules/AnalyticReporting/controllers/ARDashboardController.php');

global $mod_strings, $app_strings, $sugar_config;

$items = array();
$viewMapping = null;

$module_name = 'AnalyticReporting';
$canView = ACLController::checkAccess($module_name, 'view', true);

if ($canView) {
    $arCtrl = new ARDashboardController();
    $items = $arCtrl->getDashboardList();
    // get mapping if has access to module
    $viewMapping = $arCtrl->getViewMapping();
}

$headers = array();
$headers[] = array(
    'route'=> PlatformConnector::getUIUrl($viewMapping['urls']['list']),
    'label' => 'LBL_ALL_REPORTS',
    'acl_module'=> $module_name,
    'acl_action'=> 'list',
    'icon' => 'fa-bars',
);
foreach($items as $item) {
    $uri = PlatformConnector::getUIUrl($viewMapping['urls']['dashboard']) . $item['id'];

    $module_menu[] = array($uri, $item['title'], null);
    $headers[] = array(
        'route'=> $uri,
        'label' => $item['title'],
        'acl_module'=> $module_name,
        'acl_action'=> 'view',
        'icon' => 'fa-dashboard',
    );
}

$viewdefs[$module_name]['base']['menu']['header'] = $headers;