<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once 'include/dir_inc.php';
require_once dirname(__DIR__) . '/modules/AnalyticReporting/profiles/FunctionWrapper.php';

function post_install() {
	global $sugar_config, $sugar_version;

	// Module package list
	$module_list = array(
		'AnalyticReporting'
	);

	// DEPRECATED
	// Add to AJAX banned modules only in CE and PRO/ENT versions below 7 (where are no sidecar)
	if($GLOBALS['sugar_flavor'] == 'CE' || (float) $sugar_version < 7) {
		// Disable AjaxUI for module
		require_once 'modules/Configurator/Configurator.php';
		$cfg = new Configurator();
		$overrideArray = $cfg->readOverride();
		if(array_key_exists('addAjaxBannedModules',$overrideArray)) {
			$disabled_modules = $overrideArray['addAjaxBannedModules'];
			$updatedArray = array_merge($disabled_modules, array_diff($module_list, $disabled_modules));
		} else { 
			$updatedArray = $module_list;
		}

		$cfg->config['addAjaxBannedModules'] = empty($updatedArray) ? FALSE : $updatedArray;
		$cfg->handleOverride();
	}

	//install table for user management
	global $db;
	if (!$db->tableExists('so_users')) {

		$fieldDefs = array(
			'id' => array (
			  'name' => 'id',
			  'vname' => 'LBL_ID',
			  'type' => 'id',
			  'required' => true,
			  'reportable' => true,
			),
			'deleted' => array (
				'name' => 'deleted',
				'vname' => 'LBL_DELETED',
				'type' => 'bool',
				'default' => '0',
				'reportable' => false,
				'comment' => 'Record deletion indicator',
			),
			'shortname' => array (
				'name' => 'shortname',
				'vname' => 'LBL_SHORTNAME',
				'type' => 'varchar',
				'len' => 255,
			),
			'user_id' => array (
				'name' => 'user_id',
				'rname' => 'user_name',
				'module' => 'Users',
				'id_name' => 'user_id',
				'vname' => 'LBL_USER_ID',
				'type' => 'relate',
				'isnull' => 'false',
				'dbType' => 'id',
				'reportable' => true,
				'massupdate' => false,
			),
		);
		
		$indices = array(
			'id' => array (
				'name' => 'so_userspk',
				'type' => 'primary',
				'fields' => array (
					0 => 'id',
				),
			),
			'shortname' => array (
				'name' => 'shortname',
				'type' => 'index',
				'fields' => array (
					0 => 'shortname',
				),
			),
		);
		$db->createTableParams('so_users',$fieldDefs,$indices);
	}

	// Quick Repair & Rebuild
	$module = array('All Modules');
	$selected_actions = array('clearAll');
	require_once 'modules/Administration/QuickRepairAndRebuild.php';
	$randc = new RepairAndClear();
	$randc->repairAndClearAll($selected_actions, $module, false, false);

	$arScheduler = BeanFactory::getBean('Schedulers');
	$arScheduler->retrieve_by_string_fields(array('job' => 'function::sendScheduledReports','deleted' => '0' ));
	if(empty($arScheduler->id)){
		$arScheduler->name = 'Sapiens.BI Send Scheduled Reports';
		$arScheduler->job = 'function::sendScheduledReports';
		$arScheduler->date_time_start = '2005-01-01 00:00:00';
		$arScheduler->job_interval = '*::*::*::*::*';
		$arScheduler->status = 'Active';
		$arScheduler->catch_up = '1';
		$arScheduler->save();
	}

	$arJobs = BeanFactory::getBean('Schedulers');
	$arJobs->retrieve_by_string_fields(array('job' => 'function::executeARJobs','deleted' => '0' ));
	if(empty($arJobs->id)){
		$arJobs->name = 'Sapiens.BI Jobs';
		$arJobs->job = 'function::executeARJobs';
		$arJobs->date_time_start = '2005-01-01 00:00:00';
		$arJobs->job_interval = '*::*::*::*::*';
		$arJobs->status = 'Active';
		$arJobs->catch_up = '1';
		$arJobs->save();
	}

	$arScheduler = BeanFactory::getBean('Schedulers');
	$arScheduler->retrieve_by_string_fields(array('job' => 'function::sendScheduledDashboards','deleted' => '0' ));
	if(empty($arScheduler->id)){
		$arScheduler->name = 'Sapiens.BI Send Scheduled Dashboards';
		$arScheduler->job = 'function::sendScheduledDashboards';
		$arScheduler->date_time_start = '2005-01-01 00:00:00';
		$arScheduler->job_interval = '*::*::*::*::*';
		$arScheduler->status = 'Active';
		$arScheduler->catch_up = '1';
		$arScheduler->save();
	}

}