<?php
/**
 * Sending Multiupload files with Email WorkFlow
 * This action attaches a Files from Multiupload Field to the Action Module and 
 * Sends it as an email attachment.
*/
require_once('modules/AOW_Actions/actions/actionBase.php');

class actionSendEmailMultiupload extends actionBase {

    private $emailableModules = array();
	public $file_id = ''; 
	
    public function __construct($id = '')
    {
        parent::__construct($id);
    }

    public function loadJS()
    {
        return array('custom/modules/AOW_Actions/actions/actionSendEmailMultiupload.js');
    }

    public function edit_display($line,SugarBean $bean = null, $params = array())
    {
        global $app_list_strings;
        $email_templates_arr = get_bean_select_array(true, 'EmailTemplate', 'name', '', 'name');

        if (!in_array($bean->module_dir, getEmailableModules())) {
            unset($app_list_strings['aow_email_type_list']['Record Email']);
        }
        $targetOptions = getRelatedEmailableFields($bean->module_dir);
        if (empty($targetOptions)) {
            unset($app_list_strings['aow_email_type_list']['Related Field']);
        }
		
		
        $html = '<input type="hidden" name="aow_email_type_list" id="aow_email_type_list" value="'.get_select_options_with_id($app_list_strings['aow_email_type_list'], '').'">
				  <input type="hidden" name="aow_email_to_list" id="aow_email_to_list" value="'.get_select_options_with_id($app_list_strings['aow_email_to_list'], '').'">';

        $checked = '';
        if(isset($params['individual_email']) && $params['individual_email'])
        {
            $checked = 'CHECKED';
		}

		// Get Worflow Module Multiupload Fields
		$multiupload_fields = array('');
		foreach ($bean->field_defs as $key => $field_def)
		{
			if($field_def['type'] == 'Multiupload')
			{
				if(isset($field_def['labelValue']))
				$multiupload_fields[$key] = $field_def['labelValue'];
				else 
				{ 
					$label = translate($field_def['vname'], $bean->module_name);
					$multiupload_fields[$key] =  $label;
				}
			}
		}
		
        $html .= "<table border='0' cellpadding='0' cellspacing='0' width='100%' data-workflow-action='send-email-multiupload'>";
        $html .= "<tr>";
        $html .= '<td id="relate_label" scope="row" valign="top"><label>' . translate(
            "LBL_INDIVIDUAL_EMAILS",
            "AOW_Actions"
        ) . ':</label>';
        $html .= '</td>';

        $html .= "<td valign='top'>";
        $html .= "<input type='hidden' name='aow_actions_param[".$line."][individual_email]' value='0' >";
        $html .= "<input type='checkbox' id='aow_actions_param[".$line."][individual_email]' name='aow_actions_param[".$line."][individual_email]' value='1' $checked></td>";
        $html .= '</td>';
        if (!isset($params['email_template'])) {
            $params['email_template'] = '';
        }
        $hidden = "style='visibility: hidden;'";
        if ($params['email_template'] != '') {
            $hidden = "";
        }

        $html .= '<td id="name_label" scope="row" valign="top"><label>' . translate(
            "LBL_EMAIL_TEMPLATE",
            "AOW_Actions"
        ) . ':<span class="required">*</span></label></td>';
        $html .= "<td valign='top'>";
        $html .= "<select name='aow_actions_param[".$line."][email_template]' id='aow_actions_param_email_template".$line."' onchange='show_edit_template_link(this,".$line.");' >".get_select_options_with_id($email_templates_arr, $params['email_template'])."</select>";
        $html .= "&nbsp;<a href='javascript:open_email_template_form(".$line.")' >".translate('LBL_CREATE_EMAIL_TEMPLATE', 'AOW_Actions')."</a>";
        $html .= "&nbsp;<span name='edit_template' id='aow_actions_edit_template_link".$line."' $hidden><a href='javascript:edit_email_template_form(".$line.")' >".translate('LBL_EDIT_EMAIL_TEMPLATE', 'AOW_Actions')."</a></span>";
        $html .= "</td>";
        $html .= "</tr>";
        $html .= "<tr>";
        $html .= '<td id="name_label" scope="row" valign="top"><label>' . translate(
            "LBL_EMAIL",
            "AOW_Actions"
        ) . ':<span class="required">*</span></label></td>';
        $html .= '<td valign="top" scope="row">';
        $html .='<button type="button" onclick="add_emailLine('.$line.')"><img src="'.SugarThemeRegistry::current()->getImageURL('id-ff-add.png').'"></button>';
        $html .= '<table id="emailLine'.$line.'_table" width="100%" class="email-line"></table>';
        $html .= '</td>';

		// Multi Upload Field Selection
        $html .= '<td id="name_label" scope="row" valign="top"><label>' . translate(
            "LBL_MULTIUPLOAD_FIELD",
            "AOW_Actions"
        ) . ':<span class="required">*</span></label></td>';

        $html .= "<td valign='top'>";
        $html .= "<select name='aow_actions_param[".$line."][multiupload_field]' id='aow_actions_param_multiupload_field".$line."'>".get_select_options_with_id($multiupload_fields, $params['multiupload_field'])."</select>";
		$html .= "</td>";
		// End Multiupload Field 
		
        $html .= "</tr>";
        $html .= "</table>";

        $html .= "<script id ='aow_script".$line."'>";

        //backward compatible
        if(isset($params['email_target_type']) && !is_array($params['email_target_type'])){
            $email = '';
            switch($params['email_target_type']){
                case 'Email Address':
                    $email = $params['email'];
                    break;
                case 'Specify User':
                    $email = $params['email_user_id'];
                    break;
                case 'Related Field':
                    $email = $params['email_target'];
                    break;
            }
            $html .= "load_emailline('".$line."','to','".$params['email_target_type']."','".$email."');";
        }
        //end backward compatible

        if(isset($params['email_target_type'])){
            foreach($params['email_target_type'] as $key => $field){
                if(is_array($params['email'][$key]))
                {
                    $params['email'][$key] = json_encode($params['email'][$key]);
                }
                $html .= "load_emailline('".$line."','".$params['email_to_type'][$key]."','".$params['email_target_type'][$key]."','".$params['email'][$key]."');";
            }
        }
        $html .= "</script>";

        return $html;

    }

    private function getEmailsFromParams(SugarBean $bean, $params)
    {
        $emails = array();
        //backward compatible
        if(isset($params['email_target_type']) && !is_array($params['email_target_type'])){
            $email = '';
            switch($params['email_target_type']){
                case 'Email Address':
                    $params['email'] = array($params['email']);
                    break;
                case 'Specify User':
                    $params['email'] = array($params['email_user_id']);
                    break;
                case 'Related Field':
                    $params['email'] = array($params['email_target']);
                    break;
            }
            $params['email_target_type'] = array($params['email_target_type']);
            $params['email_to_type'] = array('to');
        }
        //end backward compatible
        if(isset($params['email_target_type'])){
            foreach($params['email_target_type'] as $key => $field){
                switch($field){
                    case 'Email Address':
                        if(trim($params['email'][$key]) != '')
                        {   
                            $emails[$params['email_to_type'][$key]][] = $params['email'][$key];
                        }
                        break;
                    case 'Specify User':
                        $user = BeanFactory::newBean('Users');
                        $user->retrieve($params['email'][$key]);
                        $user_email = $user->emailAddress->getPrimaryAddress($user);
                        if(trim($user_email) != '') {
                            $emails[$params['email_to_type'][$key]][] = $user_email;
                            $emails['template_override'][$user_email] = array('Users' => $user->id);
                        }

                        break;
                    case 'Users':
                        $users = array();
                        switch($params['email'][$key][0]) {
                            case 'security_group':
                                if(file_exists('modules/SecurityGroups/SecurityGroup.php')){
                                    require_once('modules/SecurityGroups/SecurityGroup.php');
                                    $security_group = BeanFactory::newBean('SecurityGroups');
                                    $security_group->retrieve($params['email'][$key][1]);
                                    $users = $security_group->get_linked_beans( 'users','User');
                                    $r_users = array();
                                    if($params['email'][$key][2] != ''){
                                        require_once('modules/ACLRoles/ACLRole.php');
                                        $role = BeanFactory::newBean('ACLRoles');
                                        $role->retrieve($params['email'][$key][2]);
                                        $role_users = $role->get_linked_beans( 'users','User');
                                        foreach($role_users as $role_user){
                                            $r_users[$role_user->id] = $role_user->name;
                                        }
                                    }
                                    foreach($users as $user_id => $user){
                                        if($params['email'][$key][2] != '' && !isset($r_users[$user->id])){
                                            unset($users[$user_id]);
                                        }
                                    }
                                    break;
                                }
                            //No Security Group module found - fall through.
                            // no break
                            case 'role':
                                require_once('modules/ACLRoles/ACLRole.php');
                                $role = BeanFactory::newBean('ACLRoles');
                                $role->retrieve($params['email'][$key][2]);
                                $users = $role->get_linked_beans( 'users','User');
                                break;
                            case 'all':
                            default:
                                $db = DBManagerFactory::getInstance();
                                $sql = "SELECT id from users WHERE status='Active' AND portal_only=0 ";
                                $result = $db->query($sql);
                                while ($row = $db->fetchByAssoc($result)) {
                                    $user = BeanFactory::newBean('Users');
                                    $user->retrieve($row['id']);
                                    $users[$user->id] = $user;
                                }
                                break;
                        }
                        foreach($users as $user){
                            $user_email = $user->emailAddress->getPrimaryAddress($user);
                            if(trim($user_email) != '') {
                                $emails[$params['email_to_type'][$key]][] = $user_email;
                                $emails['template_override'][$user_email] = array('Users' => $user->id);
                            }
                        }
                        break;
                    case 'Related Field':
                        $emailTarget = $params['email'][$key];
                        $relatedFields = array_merge($bean->get_related_fields(), $bean->get_linked_fields());
                        $field = $relatedFields[$emailTarget];
                        if($field['type'] == 'relate') {
                            $linkedBeans = array();
                            $idName = $field['id_name'];
                            $id = $bean->$idName;
                            $linkedBeans[] = BeanFactory::getBean($field['module'], $id);
                        } else {
                            if ($field['type'] == 'link') {
                                $relField = $field['name'];
                                if (isset($field['module']) && $field['module'] != '') {
                                    $rel_module = $field['module'];
                                } else {
                                    if ($bean->load_relationship($relField)) {
                                        $rel_module = $bean->$relField->getRelatedModuleName();
                                    }
                                }
                                $linkedBeans = $bean->get_linked_beans($relField, $rel_module);
                            } else {
                                $linkedBeans = $bean->get_linked_beans($field['link'], $field['module']);
                            }
                        }
                        if($linkedBeans){
                            foreach($linkedBeans as $linkedBean) {
                                if (!empty($linkedBean)) {
                                    $rel_email = $linkedBean->emailAddress->getPrimaryAddress($linkedBean);
                                    if (trim($rel_email) != '') {
                                        $emails[$params['email_to_type'][$key]][] = $rel_email;
                                        $emails['template_override'][$rel_email] = array($linkedBean->module_dir => $linkedBean->id);
                                    }
                                }
                            }
                        }
                        break;
                    case 'Record Email':
                        $recordEmail = $bean->emailAddress->getPrimaryAddress($bean);
                        if ($recordEmail == '' && isset($bean->email1)) {
                            $recordEmail = $bean->email1;
                        }
                        if (trim($recordEmail) != '') {
                            $emails[$params['email_to_type'][$key]][] = $recordEmail;
                        }
                        break;
                }
            }
        }
        return $emails;
    }

    public function run_action(SugarBean $bean, $params = array(), $in_save=false){
		$GLOBALS['log']->debug("Running Multiupload Email Action ");
		
        include_once('modules/EmailTemplates/EmailTemplate.php');
        $emailTemp = BeanFactory::newBean('EmailTemplates');
        $emailTemp->retrieve($params['email_template']);
		
        if($emailTemp->id == ''){
            return false;
        }
		
        $emails = $this->getEmailsFromParams($bean,$params);
		
        if (!isset($emails['to']) || empty($emails['to'])) {
            return false;
        }
		
		$this->file_id = $params['multiupload_field'];
		
		$attachments = $this->getAttachments($emailTemp);
		$ret = true;

		if(isset($params['individual_email']) && $params['individual_email']){

            foreach($emails['to'] as $email_to){
                $emailTemp = BeanFactory::newBean('EmailTemplates');
                $emailTemp->retrieve($params['email_template']);
                $template_override = isset($emails['template_override'][$email_to]) ? $emails['template_override'][$email_to] : array();
                $this->parse_template($bean, $emailTemp, $template_override);
                //$this->sendEmail(array($email_to), $emailTemp->subject, $emailTemp->body_html, $emailTemp->body, $bean, $emails['cc'],$emails['bcc'],$attachments);  
                if (!$this->sendEmail(array($email_to), $emailTemp->subject, $emailTemp->body_html, $emailTemp->body, $bean, $emails['cc'], $emails['bcc'], $attachments)) {
                    $ret = false;
                }             
            }

        } else {
            $this->parse_template($bean, $emailTemp);
			if ($emailTemp->text_only == '1') {
                $email_body_html = $emailTemp->body;
            } else {
                $email_body_html = $emailTemp->body_html;
            }
            if (!$this->sendEmail($emails['to'], $emailTemp->subject, $email_body_html, $emailTemp->body, $bean, $emails['cc'], $emails['bcc'], $attachments)) {
                $ret = false;
            } 

            //return $this->sendEmail($emails['to'], $emailTemp->subject, $email_body_html, $emailTemp->body, $bean, $emails['cc'],$emails['bcc'],$attachments);            
        }

        return $ret;
    }

    public function parse_template(SugarBean $bean, &$template, $object_override = array()){
        global $sugar_config;

        require_once('modules/AOW_Actions/actions/templateParser.php');

        $object_arr[$bean->module_dir] = $bean->id;

        foreach ($bean->field_defs as $bean_arr) {
            if ($bean_arr['type'] == 'relate') {
                if (isset($bean_arr['module']) &&  $bean_arr['module'] != '' && isset($bean_arr['id_name']) &&  $bean_arr['id_name'] != '' && $bean_arr['module'] != 'EmailAddress') {
                    $idName = $bean_arr['id_name'];
                    if (isset($bean->field_defs[$idName]) && $bean->field_defs[$idName]['source'] != 'non-db') {
                        if (!isset($object_arr[$bean_arr['module']])) {
                            $object_arr[$bean_arr['module']] = $bean->$idName;
                        }
                    }
                }
            } else {
                if ($bean_arr['type'] == 'link') {
                    if (!isset($bean_arr['module']) || $bean_arr['module'] == '') {
                        $bean_arr['module'] = getRelatedModule($bean->module_dir, $bean_arr['name']);
                    }
                    if (isset($bean_arr['module']) &&  $bean_arr['module'] != ''&& !isset($object_arr[$bean_arr['module']])&& $bean_arr['module'] != 'EmailAddress') {
                        $linkedBeans = $bean->get_linked_beans($bean_arr['name'], $bean_arr['module'], array(), 0, 1);
                        if ($linkedBeans) {
                            $linkedBean = $linkedBeans[0];
                            if (!isset($object_arr[$linkedBean->module_dir])) {
                                $object_arr[$linkedBean->module_dir] = $linkedBean->id;
                            }
                        }
                    }
                }
            }
        }

        $object_arr['Users'] = is_a($bean, 'User') ? $bean->id : $bean->assigned_user_id;

        $object_arr = array_merge($object_arr, $object_override);

        $parsedSiteUrl = parse_url($sugar_config['site_url']);
        $host = $parsedSiteUrl['host'];
        if(!isset($parsedSiteUrl['port'])) {
            $parsedSiteUrl['port'] = 80;
        }

        $port		= ($parsedSiteUrl['port'] != 80) ? ":".$parsedSiteUrl['port'] : '';
        $path		= !empty($parsedSiteUrl['path']) ? $parsedSiteUrl['path'] : "";
        $cleanUrl	= "{$parsedSiteUrl['scheme']}://{$host}{$port}{$path}";

        $url =  $cleanUrl."/index.php?module={$bean->module_dir}&action=DetailView&record={$bean->id}";

        $template->subject = str_replace("\$contact_user","\$user",$template->subject);
        $template->body_html = str_replace("\$contact_user","\$user",$template->body_html);
        $template->body = str_replace("\$contact_user","\$user",$template->body);
        $template->subject = aowTemplateParser::parse_template($template->subject, $object_arr);
        $template->body_html = aowTemplateParser::parse_template($template->body_html, $object_arr);
        $template->body_html = str_replace("\$url",$url,$template->body_html);
        $template->body_html = str_replace('$sugarurl', $sugar_config['site_url'], $template->body_html);
        $template->body = aowTemplateParser::parse_template($template->body, $object_arr);
        $template->body = str_replace("\$url", $url, $template->body);
        $template->body = str_replace('$sugarurl', $sugar_config['site_url'], $template->body);

}

    public function getAttachments(EmailTemplate $template){

        $attachments = array();
        if($template->id != ''){
			$note_bean = BeanFactory::newBean('Notes');
           	$notes = $note_bean->get_full_list('',"parent_type = 'Emails' AND parent_id = '".$template->id."'");
			
            if($notes != null){
                foreach ($notes as $note) {
                    $attachments[] = $note;
                }
            }
        }
        return $attachments;
    }

    public function sendEmail($emailTo, $emailSubject, $emailBody, $altemailBody, SugarBean $relatedBean = null, $emailCc = array(), $emailBcc = array(), $attachments)
    {
		
        require_once('modules/Emails/Email.php');
        require_once('include/SugarPHPMailer.php');

        $emailObj = BeanFactory::newBean('Emails');
        $defaults = $emailObj->getSystemDefaultEmail();
        $mail = new SugarPHPMailer();
        $mail->setMailerForSystem();
        $mail->From = $defaults['email'];
        isValidEmailAddress($mail->From);
        $mail->FromName = $defaults['name'];
        $mail->ClearAllRecipients();
        $mail->ClearReplyTos();
        $mail->Subject=from_html($emailSubject);
        $mail->Body=$emailBody;
        $mail->AltBody = $altemailBody;
		// $mail->handleAttachments($attachments);

		// CUSTOMIZATION START: Multiupload Attachments
		$all_attachments = array();
		
		$path = 'upload/multi_'.$relatedBean->id.'/'.$this->file_id.'/';
		
		if($this->file_id != '')
		{
			$multi = $this->file_id;
			//*** Either Explode Field Name or Read Directory for files uploaded
			$files =  explode(":", $relatedBean->$multi);
		
			foreach($files as $file_name)
			{
				$file_details['filename'] 		= $file_name;
				$file_details['file_mime_type'] = mime_content_type($path.$file_name);
				$file_details['location'] 		= $path.$file_name;
				$all_attachments[]				= $file_details;
			}
		}
		//Merge the Template Notes with Multiupload files
		$all_attachments = array_merge($all_attachments, $attachments);
		
		// Loop through record
		foreach($all_attachments as $attachment) {
			if($attachment->object_name == 'Note') {
				$file_name = $attachment->filename;
				$location = "upload/{$attachment->id}";
				$mime_type = $attachment->file_mime_type;
			}
			else{//Multiupload file
				$file_name 	= $attachment['filename'];
				$location 	= $attachment['location'];
				$mime_type 	= $attachment['file_mime_type'];
			}
			// Add attachment to email
			$mail->AddAttachment($location, $file_name, 'base64', $mime_type);			
		}
        
        // CUSTOMIZATION END
		
		$mail->prepForOutbound();

        if (empty($emailTo)) {
            return false;
        }

        foreach($emailTo as $to){
            $mail->AddAddress($to);
        }
        if(!empty($emailCc)){
            foreach($emailCc as $email){
                $mail->AddCC($email);
            }
        }
        if(!empty($emailBcc)){
            foreach($emailBcc as $email){
                $mail->AddBCC($email);
            }
        }
        //now create email
        if ($mail->Send()) {
            $emailObj->to_addrs= implode(',',$emailTo);
            $emailObj->cc_addrs= implode(',',$emailCc);
            $emailObj->bcc_addrs= implode(',',$emailBcc);
            $emailObj->type= 'out';
            $emailObj->deleted = '0';
            $emailObj->name = $mail->Subject;
            $emailObj->description = $mail->AltBody;
            $emailObj->description_html = $mail->Body;
            $emailObj->from_addr = $mail->From;
            isValidEmailAddress($emailObj->from_addr);
            if ($relatedBean instanceof SugarBean && !empty($relatedBean->id)) {
                $emailObj->parent_type = $relatedBean->module_dir;
                $emailObj->parent_id = $relatedBean->id;
            }
            $emailObj->date_sent_received = TimeDate::getInstance()->nowDb();
            $emailObj->modified_user_id = '1';
            $emailObj->created_by = '1';
            $emailObj->status = 'sent';
            $emailObj->save();

            // Fix for issue 1561 - Email Attachments Sent By Workflow Do Not Show In Related Activity.
            foreach ($attachments as $attachment) {
                if($attachment->object_name == 'Note') {
                    $note = BeanFactory::newBean('Notes');
                    $note->id = create_guid();
                    $note->date_entered = $attachment->date_entered;
                    $note->date_modified = $attachment->date_modified;
                    $note->modified_user_id = $attachment->modified_user_id;
                    $note->assigned_user_id = $attachment->assigned_user_id;
                    $note->new_with_id = true;
                    $note->parent_id = $emailObj->id;
                    $note->parent_type = $attachment->parent_type;
                    $note->name = $attachment->name;
                    ;
                    $note->filename = $attachment->filename;
                    $note->file_mime_type = $attachment->file_mime_type;
                    $fileLocation = "upload://{$attachment->id}";
                    $dest = "upload://{$note->id}";
                    if (!copy($fileLocation, $dest)) {
                        $GLOBALS['log']->debug("EMAIL 2.0: could not copy attachment file to $fileLocation => $dest");
                    }
                }
                else
                {
                    $note = BeanFactory::newBean('Notes');
                    $note->id = create_guid();
                    $note->new_with_id = true;
                    $note->parent_id = $relatedBean->id;
                    $note->parent_type = $relatedBean->module_dir;
                    $note->name = $attachment['name'];
                    $note->filename = $attachment['filename'];
                    $note->file_mime_type = $attachment['file_mime_type'];
                    $fileLocation = $attachment['location'];
                    $dest = "upload/{$note->id}";
                    if (!copy($fileLocation, $dest)) {
                        $GLOBALS['log']->debug("EMAIL 2.0: could not copy PDF attachment file to $fileLocation => $dest");
                    }
              }
                // SAVE THE NOTE
                $note->save();
            }// End foreach Attachment

            $GLOBALS['log']->debug("Email Sent for ID = ". $relatedBean->id." File:".$this->file_id);
            return true;
        }// Sent Email
        else{
          $GLOBALS['log']->fatal("Email count not be sent at this time for Workflow PDF Attachment Action. Please check email settings. ");
        }
        return false;
    }
}