<?php

require_once('include/UploadFile.php');

// Upload files on selection
if( isset($_FILES['fileToUpload']) && (count($_FILES['fileToUpload']['name']) > 0))
{

	// Check/Create File Upload Directory
	$record_id 		= $_REQUEST['record_id'];
	$field_name 	= $_REQUEST['file_input_id'];
	$multi_dir		= 'multi_'.$record_id.'/'.$field_name;
 	$dir_path 		= 'upload://'.$multi_dir;
 	
 	$GLOBALS['log']->debug("Dir PATH :".$dir_path);
 	//creates folders at path 
 	$writable = UploadStream::ensureDir($dir_path);

 	if(!$writable)
 	{
 		 $GLOBALS['log']->fatal( $dir_path .' is not writable.  You should try making the directory writable by the webserver');
 	}

	$upload_file = new UploadFile('fileToUpload');	
	$count = count($_FILES['fileToUpload']['name']);
	
	for ($i = 0; $i < $count; $i++) 
	{
		$file_name	 = $_FILES['fileToUpload']['name'][$i];
		$tmp_name		 = $_FILES['fileToUpload']['tmp_name'][$i];
		$destination = 'upload://'.$multi_dir.'/'.$file_name; 
		
		$msg .= " Uploaded to: ".$destination;

		if (!UploadStream::move_uploaded_file($tmp_name, $destination)) {
            $GLOBALS['log']->fatal(
                'Unable to move file to ' . $destination .
                    ' Error: '.$_FILES['fileToUpload']['error'][$i]
                );

            return false;
     }
	}

	echo json_encode("#UPLOADED SUCCESS# " . $msg);
	
}


// Remove File
if($_POST['file_name'] != '') {
  $file = trim($_POST['file_name']);
  $file_path = "multi_{$_POST['record_id']}/{$_POST['field_id']}/$file";

  // Delete File 
  $upload_file = new UploadFile();
  $deleted = $upload_file->unlink_file($file_path);

  if ($deleted) {
    echo json_encode("#FILE DELETED#");
  } else {
    echo json_encode("#FILE DOES NOT EXISTS. PATH = $file_path");
  }
}

?>